<?php

namespace ChurchCRM\model\ChurchCRM\Map;

use ChurchCRM\model\ChurchCRM\DonationFund;
use ChurchCRM\model\ChurchCRM\DonationFundQuery;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\InstancePoolTrait;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\DataFetcher\DataFetcherInterface;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\RelationMap;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Map\TableMapTrait;


/**
 * This class defines the structure of the 'donationfund_fun' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 */
class DonationFundTableMap extends TableMap
{
    use InstancePoolTrait;
    use TableMapTrait;

    /**
     * The (dot-path) name of this class
     */
    const CLASS_NAME = 'ChurchCRM.model.ChurchCRM.Map.DonationFundTableMap';

    /**
     * The default database name for this class
     */
    const DATABASE_NAME = 'default';

    /**
     * The table name for this class
     */
    const TABLE_NAME = 'donationfund_fun';

    /**
     * The related Propel class for this table
     */
    const OM_CLASS = '\\ChurchCRM\\model\\ChurchCRM\\DonationFund';

    /**
     * A class that can be returned by this tableMap
     */
    const CLASS_DEFAULT = 'ChurchCRM.model.ChurchCRM.DonationFund';

    /**
     * The total number of columns
     */
    const NUM_COLUMNS = 5;

    /**
     * The number of lazy-loaded columns
     */
    const NUM_LAZY_LOAD_COLUMNS = 0;

    /**
     * The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS)
     */
    const NUM_HYDRATE_COLUMNS = 5;

    /**
     * the column name for the fun_ID field
     */
    const COL_FUN_ID = 'donationfund_fun.fun_ID';

    /**
     * the column name for the fun_Active field
     */
    const COL_FUN_ACTIVE = 'donationfund_fun.fun_Active';

    /**
     * the column name for the fun_Name field
     */
    const COL_FUN_NAME = 'donationfund_fun.fun_Name';

    /**
     * the column name for the fun_Description field
     */
    const COL_FUN_DESCRIPTION = 'donationfund_fun.fun_Description';

    /**
     * the column name for the fun_Order field
     */
    const COL_FUN_ORDER = 'donationfund_fun.fun_Order';

    /**
     * The default string format for model objects of the related table
     */
    const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldNames[self::TYPE_PHPNAME][0] = 'Id'
     */
    protected static $fieldNames = array (
        self::TYPE_PHPNAME       => array('Id', 'Active', 'Name', 'Description', 'Order', ),
        self::TYPE_CAMELNAME     => array('id', 'active', 'name', 'description', 'order', ),
        self::TYPE_COLNAME       => array(DonationFundTableMap::COL_FUN_ID, DonationFundTableMap::COL_FUN_ACTIVE, DonationFundTableMap::COL_FUN_NAME, DonationFundTableMap::COL_FUN_DESCRIPTION, DonationFundTableMap::COL_FUN_ORDER, ),
        self::TYPE_FIELDNAME     => array('fun_ID', 'fun_Active', 'fun_Name', 'fun_Description', 'fun_Order', ),
        self::TYPE_NUM           => array(0, 1, 2, 3, 4, )
    );

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldKeys[self::TYPE_PHPNAME]['Id'] = 0
     */
    protected static $fieldKeys = array (
        self::TYPE_PHPNAME       => array('Id' => 0, 'Active' => 1, 'Name' => 2, 'Description' => 3, 'Order' => 4, ),
        self::TYPE_CAMELNAME     => array('id' => 0, 'active' => 1, 'name' => 2, 'description' => 3, 'order' => 4, ),
        self::TYPE_COLNAME       => array(DonationFundTableMap::COL_FUN_ID => 0, DonationFundTableMap::COL_FUN_ACTIVE => 1, DonationFundTableMap::COL_FUN_NAME => 2, DonationFundTableMap::COL_FUN_DESCRIPTION => 3, DonationFundTableMap::COL_FUN_ORDER => 4, ),
        self::TYPE_FIELDNAME     => array('fun_ID' => 0, 'fun_Active' => 1, 'fun_Name' => 2, 'fun_Description' => 3, 'fun_Order' => 4, ),
        self::TYPE_NUM           => array(0, 1, 2, 3, 4, )
    );

    /**
     * Holds a list of column names and their normalized version.
     *
     * @var string[]
     */
    protected $normalizedColumnNameMap = [

        'Id' => 'FUN_ID',
        'DonationFund.Id' => 'FUN_ID',
        'id' => 'FUN_ID',
        'donationFund.id' => 'FUN_ID',
        'DonationFundTableMap::COL_FUN_ID' => 'FUN_ID',
        'COL_FUN_ID' => 'FUN_ID',
        'fun_ID' => 'FUN_ID',
        'donationfund_fun.fun_ID' => 'FUN_ID',
        'Active' => 'FUN_ACTIVE',
        'DonationFund.Active' => 'FUN_ACTIVE',
        'active' => 'FUN_ACTIVE',
        'donationFund.active' => 'FUN_ACTIVE',
        'DonationFundTableMap::COL_FUN_ACTIVE' => 'FUN_ACTIVE',
        'COL_FUN_ACTIVE' => 'FUN_ACTIVE',
        'fun_Active' => 'FUN_ACTIVE',
        'donationfund_fun.fun_Active' => 'FUN_ACTIVE',
        'Name' => 'FUN_NAME',
        'DonationFund.Name' => 'FUN_NAME',
        'name' => 'FUN_NAME',
        'donationFund.name' => 'FUN_NAME',
        'DonationFundTableMap::COL_FUN_NAME' => 'FUN_NAME',
        'COL_FUN_NAME' => 'FUN_NAME',
        'fun_Name' => 'FUN_NAME',
        'donationfund_fun.fun_Name' => 'FUN_NAME',
        'Description' => 'FUN_DESCRIPTION',
        'DonationFund.Description' => 'FUN_DESCRIPTION',
        'description' => 'FUN_DESCRIPTION',
        'donationFund.description' => 'FUN_DESCRIPTION',
        'DonationFundTableMap::COL_FUN_DESCRIPTION' => 'FUN_DESCRIPTION',
        'COL_FUN_DESCRIPTION' => 'FUN_DESCRIPTION',
        'fun_Description' => 'FUN_DESCRIPTION',
        'donationfund_fun.fun_Description' => 'FUN_DESCRIPTION',
        'Order' => 'FUN_ORDER',
        'DonationFund.Order' => 'FUN_ORDER',
        'order' => 'FUN_ORDER',
        'donationFund.order' => 'FUN_ORDER',
        'DonationFundTableMap::COL_FUN_ORDER' => 'FUN_ORDER',
        'COL_FUN_ORDER' => 'FUN_ORDER',
        'fun_Order' => 'FUN_ORDER',
        'donationfund_fun.fun_Order' => 'FUN_ORDER',
    ];

    /**
     * Initialize the table attributes and columns
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws PropelException
     */
    public function initialize()
    {
        // attributes
        $this->setName('donationfund_fun');
        $this->setPhpName('DonationFund');
        $this->setIdentifierQuoting(false);
        $this->setClassName('\\ChurchCRM\\model\\ChurchCRM\\DonationFund');
        $this->setPackage('ChurchCRM.model.ChurchCRM');
        $this->setUseIdGenerator(true);
        // columns
        $this->addPrimaryKey('fun_ID', 'Id', 'TINYINT', true, 3, null);
        $this->addColumn('fun_Active', 'Active', 'CHAR', true, null, 'true');
        $this->addColumn('fun_Name', 'Name', 'VARCHAR', false, 30, null);
        $this->addColumn('fun_Description', 'Description', 'VARCHAR', false, 100, null);
        $this->addColumn('fun_Order', 'Order', 'INTEGER', true, null, 0);
    } // initialize()

    /**
     * Build the RelationMap objects for this table relationships
     */
    public function buildRelations()
    {
        $this->addRelation('Pledge', '\\ChurchCRM\\model\\ChurchCRM\\Pledge', RelationMap::ONE_TO_MANY, array (
  0 =>
  array (
    0 => ':plg_fundID',
    1 => ':fun_ID',
  ),
), null, null, 'Pledges', false);
    } // buildRelations()

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param array  $row       resultset row.
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return string The primary key hash of the row
     */
    public static function getPrimaryKeyHashFromRow($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        // If the PK cannot be derived from the row, return NULL.
        if ($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] === null) {
            return null;
        }

        return null === $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] || is_scalar($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)]) || is_callable([$row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)], '__toString']) ? (string) $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] : $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param array  $row       resultset row.
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        return (int) $row[
            $indexType == TableMap::TYPE_NUM
                ? 0 + $offset
                : self::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)
        ];
    }

    /**
     * The class that the tableMap will make instances of.
     *
     * If $withPrefix is true, the returned path
     * uses a dot-path notation which is translated into a path
     * relative to a location on the PHP include_path.
     * (e.g. path.to.MyClass -> 'path/to/MyClass.php')
     *
     * @param boolean $withPrefix Whether or not to return the path with the class name
     * @return string path.to.ClassName
     */
    public static function getOMClass($withPrefix = true)
    {
        return $withPrefix ? DonationFundTableMap::CLASS_DEFAULT : DonationFundTableMap::OM_CLASS;
    }

    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param array  $row       row returned by DataFetcher->fetch().
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                 One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return array           (DonationFund object, last column rank)
     */
    public static function populateObject($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        $key = DonationFundTableMap::getPrimaryKeyHashFromRow($row, $offset, $indexType);
        if (null !== ($obj = DonationFundTableMap::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $offset, true); // rehydrate
            $col = $offset + DonationFundTableMap::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = DonationFundTableMap::OM_CLASS;
            /** @var DonationFund $obj */
            $obj = new $cls();
            $col = $obj->hydrate($row, $offset, false, $indexType);
            DonationFundTableMap::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @param DataFetcherInterface $dataFetcher
     * @return array
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function populateObjects(DataFetcherInterface $dataFetcher)
    {
        $results = array();

        // set the class once to avoid overhead in the loop
        $cls = static::getOMClass(false);
        // populate the object(s)
        while ($row = $dataFetcher->fetch()) {
            $key = DonationFundTableMap::getPrimaryKeyHashFromRow($row, 0, $dataFetcher->getIndexType());
            if (null !== ($obj = DonationFundTableMap::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                /** @var DonationFund $obj */
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                DonationFundTableMap::addInstanceToPool($obj, $key);
            } // if key exists
        }

        return $results;
    }
    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param Criteria $criteria object containing the columns to add.
     * @param string   $alias    optional table alias
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function addSelectColumns(Criteria $criteria, $alias = null)
    {
        if (null === $alias) {
            $criteria->addSelectColumn(DonationFundTableMap::COL_FUN_ID);
            $criteria->addSelectColumn(DonationFundTableMap::COL_FUN_ACTIVE);
            $criteria->addSelectColumn(DonationFundTableMap::COL_FUN_NAME);
            $criteria->addSelectColumn(DonationFundTableMap::COL_FUN_DESCRIPTION);
            $criteria->addSelectColumn(DonationFundTableMap::COL_FUN_ORDER);
        } else {
            $criteria->addSelectColumn($alias . '.fun_ID');
            $criteria->addSelectColumn($alias . '.fun_Active');
            $criteria->addSelectColumn($alias . '.fun_Name');
            $criteria->addSelectColumn($alias . '.fun_Description');
            $criteria->addSelectColumn($alias . '.fun_Order');
        }
    }

    /**
     * Remove all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be removed as they are only loaded on demand.
     *
     * @param Criteria $criteria object containing the columns to remove.
     * @param string   $alias    optional table alias
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function removeSelectColumns(Criteria $criteria, $alias = null)
    {
        if (null === $alias) {
            $criteria->removeSelectColumn(DonationFundTableMap::COL_FUN_ID);
            $criteria->removeSelectColumn(DonationFundTableMap::COL_FUN_ACTIVE);
            $criteria->removeSelectColumn(DonationFundTableMap::COL_FUN_NAME);
            $criteria->removeSelectColumn(DonationFundTableMap::COL_FUN_DESCRIPTION);
            $criteria->removeSelectColumn(DonationFundTableMap::COL_FUN_ORDER);
        } else {
            $criteria->removeSelectColumn($alias . '.fun_ID');
            $criteria->removeSelectColumn($alias . '.fun_Active');
            $criteria->removeSelectColumn($alias . '.fun_Name');
            $criteria->removeSelectColumn($alias . '.fun_Description');
            $criteria->removeSelectColumn($alias . '.fun_Order');
        }
    }

    /**
     * Returns the TableMap related to this object.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function getTableMap()
    {
        return Propel::getServiceContainer()->getDatabaseMap(DonationFundTableMap::DATABASE_NAME)->getTable(DonationFundTableMap::TABLE_NAME);
    }

    /**
     * Add a TableMap instance to the database for this tableMap class.
     */
    public static function buildTableMap()
    {
        $dbMap = Propel::getServiceContainer()->getDatabaseMap(DonationFundTableMap::DATABASE_NAME);
        if (!$dbMap->hasTable(DonationFundTableMap::TABLE_NAME)) {
            $dbMap->addTableObject(new DonationFundTableMap());
        }
    }

    /**
     * Performs a DELETE on the database, given a DonationFund or Criteria object OR a primary key value.
     *
     * @param mixed               $values Criteria or DonationFund object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param  ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
     public static function doDelete($values, ConnectionInterface $con = null)
     {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(DonationFundTableMap::DATABASE_NAME);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = $values;
        } elseif ($values instanceof \ChurchCRM\model\ChurchCRM\DonationFund) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(DonationFundTableMap::DATABASE_NAME);
            $criteria->add(DonationFundTableMap::COL_FUN_ID, (array) $values, Criteria::IN);
        }

        $query = DonationFundQuery::create()->mergeWith($criteria);

        if ($values instanceof Criteria) {
            DonationFundTableMap::clearInstancePool();
        } elseif (!is_object($values)) { // it's a primary key, or an array of pks
            foreach ((array) $values as $singleval) {
                DonationFundTableMap::removeInstanceFromPool($singleval);
            }
        }

        return $query->delete($con);
    }

    /**
     * Deletes all rows from the donationfund_fun table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public static function doDeleteAll(ConnectionInterface $con = null)
    {
        return DonationFundQuery::create()->doDeleteAll($con);
    }

    /**
     * Performs an INSERT on the database, given a DonationFund or Criteria object.
     *
     * @param mixed               $criteria Criteria or DonationFund object containing data that is used to create the INSERT statement.
     * @param ConnectionInterface $con the ConnectionInterface connection to use
     * @return mixed           The new primary key.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function doInsert($criteria, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(DonationFundTableMap::DATABASE_NAME);
        }

        if ($criteria instanceof Criteria) {
            $criteria = clone $criteria; // rename for clarity
        } else {
            $criteria = $criteria->buildCriteria(); // build Criteria from DonationFund object
        }

        if ($criteria->containsKey(DonationFundTableMap::COL_FUN_ID) && $criteria->keyContainsValue(DonationFundTableMap::COL_FUN_ID) ) {
            throw new PropelException('Cannot insert a value for auto-increment primary key ('.DonationFundTableMap::COL_FUN_ID.')');
        }


        // Set the correct dbName
        $query = DonationFundQuery::create()->mergeWith($criteria);

        // use transaction because $criteria could contain info
        // for more than one table (I guess, conceivably)
        return $con->transaction(function () use ($con, $query) {
            return $query->doInsert($con);
        });
    }

} // DonationFundTableMap
// This is the static code needed to register the TableMap for this table with the main Propel class.
//
DonationFundTableMap::buildTableMap();
