/*
 * ATTENTION: The "eval" devtool has been used (maybe by default in mode: "development").
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
/******/ (() => {
    // webpackBootstrap
    /******/ "use strict";
    /******/ var __webpack_modules__ = {
        /***/ "./webpack/kiosk/index.ts"(
            /*!********************************!*\
  !*** ./webpack/kiosk/index.ts ***!
  \********************************/
            __unused_webpack_module,
            __webpack_exports__,
            __webpack_require__,
        ) {
            eval(
                '{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   kiosk: () => (/* reexport safe */ _kiosk_jsom__WEBPACK_IMPORTED_MODULE_0__.kiosk)\n/* harmony export */ });\n/* harmony import */ var _kiosk_jsom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./kiosk-jsom */ "./webpack/kiosk/kiosk-jsom.ts");\n/* harmony import */ var _kiosk_events__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./kiosk-events */ "./webpack/kiosk/kiosk-events.ts");\n/**\n * Kiosk Webpack Entry Point\n *\n * Bundles the kiosk JSOM (JavaScript Object Model) and event handlers\n * for the Sunday School check-in kiosk functionality.\n */\n// Import and initialize the kiosk module\n\n// Import event handlers (auto-registers on import)\n\n// Export for potential external use\n\n\n\n//# sourceURL=webpack://churchcrm/./webpack/kiosk/index.ts?\n}',
            );

            /***/
        },

        /***/ "./webpack/kiosk/kiosk-events.ts"(
            /*!***************************************!*\
  !*** ./webpack/kiosk/kiosk-events.ts ***!
  \***************************************/
            __unused_webpack_module,
            __webpack_exports__,
            __webpack_require__,
        ) {
            eval(
                "{__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _kiosk_jsom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./kiosk-jsom */ \"./webpack/kiosk/kiosk-jsom.ts\");\n/**\n * Kiosk Event Handlers\n *\n * Event handlers for the kiosk interface.\n * These bind to DOM elements and delegate to the kiosk JSOM.\n */\n\n// Listen for any click event on the document\n$(document).on('click', function () {\n    // Sadly, we can't enter full screen on load, but we can do\n    // it the first time anything is clicked.\n    _kiosk_jsom__WEBPACK_IMPORTED_MODULE_0__.kiosk.enterFullScreen();\n});\n$(function () {\n    _kiosk_jsom__WEBPACK_IMPORTED_MODULE_0__.kiosk.startEventLoop();\n});\n$(document).on('click', '.widget-user-header', function (event) {\n    const personId = $(event.currentTarget).data('personid');\n    _kiosk_jsom__WEBPACK_IMPORTED_MODULE_0__.kiosk.displayPersonInfo(personId);\n});\n$(document).on('click', '.parentAlertButton', function (event) {\n    const personId = $(event.currentTarget).data('personid');\n    _kiosk_jsom__WEBPACK_IMPORTED_MODULE_0__.kiosk.triggerNotification(personId);\n});\n$(document).on('click', '.checkinButton', function (event) {\n    const personId = $(event.currentTarget).data('personid');\n    _kiosk_jsom__WEBPACK_IMPORTED_MODULE_0__.kiosk.checkInPerson(personId);\n});\n$(document).on('click', '.checkoutButton', function (event) {\n    const personId = $(event.currentTarget).data('personid');\n    _kiosk_jsom__WEBPACK_IMPORTED_MODULE_0__.kiosk.checkOutPerson(personId);\n});\n$(document).on('click', '#checkoutAllBtn', function (event) {\n    event.preventDefault();\n    _kiosk_jsom__WEBPACK_IMPORTED_MODULE_0__.kiosk.checkOutAll();\n});\n\n\n//# sourceURL=webpack://churchcrm/./webpack/kiosk/kiosk-events.ts?\n}",
            );

            /***/
        },

        /***/ "./webpack/kiosk/kiosk-jsom.ts"(
            /*!*************************************!*\
  !*** ./webpack/kiosk/kiosk-jsom.ts ***!
  \*************************************/
            __unused_webpack_module,
            __webpack_exports__,
            __webpack_require__,
        ) {
            eval(
                "{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   kiosk: () => (/* binding */ kiosk)\n/* harmony export */ });\n/**\n * Kiosk JSOM (JavaScript Object Model)\n *\n * Main kiosk logic for Sunday School check-in functionality.\n * Requires: moment.js (loaded globally), jQuery\n */\n// Helper to access window.CRM safely\nfunction getCRM() {\n    return window.CRM || {};\n}\n// Module-level state (avoids global window.CRM pollution)\nconst kioskState = {\n    notificationsEnabled: false,\n    kioskAssignmentId: undefined,\n    kioskEventLoop: undefined,\n    countdownInterval: undefined,\n};\n/**\n * HTML escape helper to prevent XSS\n */\nfunction escapeHtml(text) {\n    if (text === null || text === undefined)\n        return '';\n    const div = document.createElement('div');\n    div.textContent = String(text);\n    return div.innerHTML;\n}\n/**\n * Make API request to kiosk device endpoints\n */\nfunction APIRequest(options) {\n    const ajaxOptions = {\n        method: options.method || 'GET',\n        url: getCRM().root + '/kiosk/device/' + options.path,\n        dataType: 'json',\n        contentType: 'application/json',\n        data: options.data,\n    };\n    return $.ajax(ajaxOptions);\n}\n/**\n * Get photo URL for a person\n */\nfunction getPhotoUrl(personId) {\n    return getCRM().root + '/kiosk/device/activeClassMember/' + personId + '/photo';\n}\n/**\n * Render a class member card in the appropriate section\n */\nfunction renderClassMember(classMember) {\n    const existingDiv = $('#personId-' + classMember.personId);\n    if (existingDiv.length > 0) {\n        // Card already exists, just update status\n    }\n    else {\n        // Create member row\n        const memberRow = $('<div>', {\n            id: 'personId-' + classMember.personId,\n            class: 'kiosk-member',\n        });\n        // Avatar\n        const avatarDiv = $('<div>', { class: 'kiosk-member-avatar' });\n        if (classMember.hasPhoto) {\n            avatarDiv.append($('<img>', {\n                src: getPhotoUrl(classMember.personId),\n                alt: classMember.displayName,\n            }));\n        }\n        else {\n            // Gender icon - 1 = Male, 2 = Female\n            let iconClass = 'fas fa-user';\n            let iconColor = '#6c757d';\n            if (classMember.gender === 1) {\n                iconClass = 'fas fa-male';\n                iconColor = '#007bff';\n            }\n            else if (classMember.gender === 2) {\n                iconClass = 'fas fa-female';\n                iconColor = '#e83e8c';\n            }\n            avatarDiv.append($('<i>', {\n                class: iconClass,\n                style: 'font-size: 24px; color: ' + iconColor + ';',\n            }));\n        }\n        // Info section\n        const infoDiv = $('<div>', { class: 'kiosk-member-info' });\n        // Name with optional birthday cake for upcoming/recent birthdays\n        const nameDiv = $('<div>', { class: 'kiosk-member-name' });\n        nameDiv.text(classMember.displayName);\n        if (classMember.birthdayUpcoming || classMember.birthdayRecent) {\n            nameDiv.append($('<i>', {\n                class: 'fas fa-birthday-cake ml-2',\n                style: 'color: #e83e8c;',\n                title: classMember.birthdayUpcoming ? 'Birthday coming up!' : 'Recent birthday!',\n            }));\n        }\n        infoDiv.append(nameDiv);\n        // Show age if available\n        if (classMember.age !== null && classMember.age >= 0) {\n            infoDiv.append($('<div>', {\n                class: 'kiosk-member-age',\n                text: classMember.age + ' yrs',\n            }));\n        }\n        // Actions - icon-only buttons\n        const actionsDiv = $('<div>', { class: 'kiosk-member-actions' });\n        const checkinBtn = $('<button>', {\n            class: 'kiosk-btn kiosk-btn-checkin checkinButton',\n            'data-personid': classMember.personId,\n            title: 'Check In',\n        }).append($('<i>', { class: 'fas fa-sign-in-alt' }));\n        actionsDiv.append(checkinBtn);\n        // Only show alert button for checked-in students when notifications are enabled\n        if (classMember.status == 1 && kioskState.notificationsEnabled) {\n            const alertBtn = $('<button>', {\n                class: 'kiosk-btn kiosk-btn-alert parentAlertButton',\n                'data-personid': classMember.personId,\n                title: 'Parent Alert',\n            }).append($('<i>', { class: 'fas fa-bell' }));\n            actionsDiv.append(alertBtn);\n        }\n        memberRow.append(avatarDiv).append(infoDiv).append(actionsDiv);\n        // Add to appropriate section based on status\n        if (classMember.status == 1) {\n            $('#checkedInList').append(memberRow);\n        }\n        else {\n            $('#notCheckedInList').append(memberRow);\n        }\n    }\n    // Update visual state\n    if (classMember.status == 1) {\n        setCheckedIn(classMember.personId);\n    }\n    else {\n        setCheckedOut(classMember.personId);\n    }\n}\n/**\n * Update the member counts in the UI\n */\nfunction updateMemberCounts() {\n    const checkedIn = $('#checkedInList .kiosk-member').length;\n    const notCheckedIn = $('#notCheckedInList .kiosk-member').length;\n    $('#checkedInCount').text(checkedIn);\n    $('#notCheckedInCount').text(notCheckedIn);\n    $('#checkedInSectionCount').text(checkedIn);\n    $('#notCheckedInSectionCount').text(notCheckedIn);\n    // Show/hide Checkout All button based on checked-in count\n    if (checkedIn > 0) {\n        $('#checkoutAllBtn').show();\n    }\n    else {\n        $('#checkoutAllBtn').hide();\n    }\n    // Show/hide empty state messages\n    if (checkedIn === 0) {\n        if ($('#checkedInList .kiosk-empty').length === 0) {\n            $('#checkedInList').html('<div class=\"kiosk-empty\">' +\n                '<i class=\"fas fa-user-clock\"></i>' +\n                '<p>No one checked in yet</p>' +\n                '</div>');\n        }\n    }\n    else {\n        $('#checkedInList .kiosk-empty').remove();\n    }\n    if (notCheckedIn === 0) {\n        if ($('#notCheckedInList .kiosk-empty').length === 0) {\n            $('#notCheckedInList').html('<div class=\"kiosk-empty\">' +\n                '<i class=\"fas fa-check-double text-success\"></i>' +\n                '<p>Everyone is here!</p>' +\n                '</div>');\n        }\n    }\n    else {\n        $('#notCheckedInList .kiosk-empty').remove();\n    }\n}\n/**\n * Render the birthday section banner\n */\nfunction renderBirthdaySection(birthdayPeople) {\n    const birthdayList = $('#birthdayList');\n    const birthdayBanner = $('#birthdayBanner');\n    birthdayList.empty();\n    if (!birthdayPeople || birthdayPeople.length === 0) {\n        // Hide banner when no birthdays\n        birthdayBanner.hide();\n        $('.kiosk-section').removeClass('has-birthday-banner');\n        $('#birthdayCount').text('0');\n        return;\n    }\n    // Show banner and adjust section heights\n    birthdayBanner.show();\n    $('.kiosk-section').addClass('has-birthday-banner');\n    // Sort by birthday (upcoming first, then recent)\n    const monthNames = ['', 'Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];\n    // Separate upcoming and recent\n    const upcoming = birthdayPeople.filter((p) => p.birthdayUpcoming);\n    const recent = birthdayPeople.filter((p) => p.birthdayRecent && !p.birthdayUpcoming);\n    // Render all birthday cards in a horizontal layout\n    upcoming.forEach((person) => {\n        birthdayList.append(renderBirthdayCard(person, monthNames, 'upcoming'));\n    });\n    recent.forEach((person) => {\n        birthdayList.append(renderBirthdayCard(person, monthNames, 'recent'));\n    });\n    $('#birthdayCount').text(birthdayPeople.length);\n}\n/**\n * Render a birthday card\n */\nfunction renderBirthdayCard(person, monthNames, cardType) {\n    let cardClass = 'birthday-card';\n    const today = new Date();\n    const isToday = person.birthdayToday || (person.birthMonth === today.getMonth() + 1 && person.birthDay === today.getDate());\n    if (isToday) {\n        cardClass += ' today';\n    }\n    else if (cardType === 'upcoming') {\n        cardClass += ' upcoming';\n    }\n    else if (cardType === 'recent') {\n        cardClass += ' recent';\n    }\n    const card = $('<div>', { class: cardClass });\n    // Avatar\n    const avatarDiv = $('<div>', { class: 'birthday-avatar' });\n    if (person.hasPhoto) {\n        avatarDiv.append($('<img>', {\n            src: getPhotoUrl(person.personId),\n            alt: person.displayName,\n        }));\n    }\n    else {\n        avatarDiv.append($('<i>', { class: 'fas fa-birthday-cake' }));\n    }\n    card.append(avatarDiv);\n    // Info\n    const infoDiv = $('<div>', { class: 'birthday-info' });\n    infoDiv.append($('<div>', { class: 'birthday-name', text: person.firstName }));\n    const birthMonthIndex = person.birthMonth ?? 0;\n    let dateText = monthNames[birthMonthIndex] + ' ' + person.birthDay;\n    let dateClass = 'birthday-date';\n    if (isToday) {\n        dateText = '🎉 Today!';\n        dateClass += ' today';\n    }\n    infoDiv.append($('<div>', { class: dateClass, text: dateText }));\n    card.append(infoDiv);\n    // Age badge (if age is available and it's upcoming/today)\n    if (person.age !== null && (cardType === 'upcoming' || isToday)) {\n        const turningAge = isToday ? person.age : person.age + 1;\n        card.append($('<span>', { class: 'birthday-age-badge', text: 'Turning ' + turningAge }));\n    }\n    return card;\n}\n/**\n * Update active class members from API\n */\nfunction updateActiveClassMembers() {\n    APIRequest({\n        path: 'activeClassMembers',\n    })\n        .done((data) => {\n        if (!data || !data.People || data.People.length === 0) {\n            // No members found - show helpful debug info\n            $('#classMemberContainer').html(renderNoMembersMessage());\n            return;\n        }\n        // Store notifications enabled flag for use in rendering\n        kioskState.notificationsEnabled = data.notificationsEnabled || false;\n        // Clear loading state on first load\n        if ($('#notCheckedInList .fa-spinner').length > 0) {\n            $('#checkedInList').empty();\n            $('#notCheckedInList').empty();\n            $('#birthdayList').empty();\n        }\n        // Update group name in headers if provided\n        if (data.GroupName) {\n            $('.kiosk-group-name').text(data.GroupName);\n        }\n        // Collect birthday people for separate section\n        const birthdayPeople = [];\n        data.People.forEach((d) => {\n            const memberData = {\n                displayName: d.FirstName + ' ' + d.LastName,\n                firstName: d.FirstName,\n                classRole: d.RoleName,\n                personId: d.Id,\n                status: d.status,\n                gender: d.Gender,\n                hasPhoto: d.hasPhoto,\n                age: d.age,\n                birthdayThisMonth: d.birthdayThisMonth,\n                birthdayUpcoming: d.birthdayUpcoming,\n                birthdayRecent: d.birthdayRecent,\n                birthdayToday: d.birthdayToday,\n                birthDay: d.birthDay,\n                birthMonth: d.birthMonth,\n            };\n            renderClassMember(memberData);\n            // Add to birthday list if upcoming or recent\n            if (d.birthdayUpcoming || d.birthdayRecent) {\n                birthdayPeople.push(memberData);\n            }\n        });\n        // Render birthday section\n        renderBirthdaySection(birthdayPeople);\n        // Update counts after rendering\n        updateMemberCounts();\n    })\n        .fail((xhr) => {\n        // API error - show debug info\n        let errorMessage = 'Unable to load class members';\n        if (xhr.responseJSON && xhr.responseJSON.message) {\n            errorMessage = xhr.responseJSON.message;\n        }\n        else if (xhr.status === 500) {\n            errorMessage = 'Server error - the event may not be linked to a group';\n        }\n        $('#classMemberContainer').html(renderErrorMessage(errorMessage, xhr.status));\n    });\n}\n/**\n * Render no members message with troubleshooting\n */\nfunction renderNoMembersMessage() {\n    return ('<div class=\"kiosk-status-container\">' +\n        '<div class=\"card kiosk-status-card card-warning\">' +\n        '<div class=\"card-header\">' +\n        '<h3 class=\"card-title\"><i class=\"fas fa-users-slash mr-2\"></i>No Class Members Found</h3>' +\n        '</div>' +\n        '<div class=\"card-body\">' +\n        '<div class=\"kiosk-status-icon text-warning\">' +\n        '<i class=\"fas fa-users-slash\"></i>' +\n        '</div>' +\n        '<p class=\"text-muted\">This kiosk is assigned to an event, but no members are available for check-in.</p>' +\n        '<div class=\"kiosk-instructions\">' +\n        '<h5><i class=\"fas fa-info-circle mr-2\"></i>Possible Causes</h5>' +\n        '<ol>' +\n        '<li><strong>Event not linked to a Group:</strong> Edit the event and associate it with a Sunday School or other group</li>' +\n        '<li><strong>Group has no members:</strong> Add people to the group that is linked to this event</li>' +\n        '<li><strong>Event timing:</strong> The event may not be currently active (check start/end times)</li>' +\n        '</ol>' +\n        '</div>' +\n        '<div class=\"kiosk-instructions mt-3\">' +\n        '<h5><i class=\"fas fa-wrench mr-2\"></i>How to Fix</h5>' +\n        '<ol class=\"small\">' +\n        '<li>Go to <strong>Events</strong> in ChurchCRM</li>' +\n        '<li>Edit this event and set the <strong>Group</strong> field</li>' +\n        '<li>Ensure the group has members assigned</li>' +\n        '<li>Refresh this kiosk page</li>' +\n        '</ol>' +\n        '</div>' +\n        '</div>' +\n        '</div>' +\n        '</div>');\n}\n/**\n * Render error message with troubleshooting\n */\nfunction renderErrorMessage(message, statusCode) {\n    return ('<div class=\"kiosk-status-container\">' +\n        '<div class=\"card kiosk-status-card card-danger\">' +\n        '<div class=\"card-header\">' +\n        '<h3 class=\"card-title\"><i class=\"fas fa-exclamation-triangle mr-2\"></i>Error Loading Members</h3>' +\n        '</div>' +\n        '<div class=\"card-body\">' +\n        '<div class=\"kiosk-status-icon text-danger\">' +\n        '<i class=\"fas fa-exclamation-triangle\"></i>' +\n        '</div>' +\n        '<p class=\"text-muted\">' +\n        escapeHtml(message) +\n        '</p>' +\n        (statusCode ? '<p class=\"small text-muted\">HTTP Status: ' + escapeHtml(String(statusCode)) + '</p>' : '') +\n        '<div class=\"kiosk-instructions\">' +\n        '<h5><i class=\"fas fa-lightbulb mr-2\"></i>Troubleshooting</h5>' +\n        '<ul>' +\n        '<li>Verify the event is linked to a <strong>Group</strong></li>' +\n        '<li>Check that the event start/end times are correct</li>' +\n        '<li>Ensure the group has members</li>' +\n        '<li>Check the server logs for more details</li>' +\n        '</ul>' +\n        '</div>' +\n        '</div>' +\n        '</div>' +\n        '</div>');\n}\n/**\n * Helper function to safely parse JSON assignment data\n */\nfunction parseAssignment(assignmentJson) {\n    if (!assignmentJson) {\n        return null;\n    }\n    try {\n        return JSON.parse(assignmentJson);\n    }\n    catch (e) {\n        // Log the error but do not break the heartbeat loop\n        // eslint-disable-next-line no-console\n        console.error('Failed to parse kiosk Assignment JSON:', e, assignmentJson);\n        return null;\n    }\n}\n/**\n * Heartbeat function to check kiosk status\n */\nfunction heartbeat() {\n    APIRequest({\n        path: 'heartbeat',\n    }).done((data) => {\n        const thisAssignment = parseAssignment(data.Assignment);\n        if (kioskState.kioskAssignmentId === undefined) {\n            kioskState.kioskAssignmentId = thisAssignment || undefined;\n        }\n        else if (thisAssignment &&\n            kioskState.kioskAssignmentId &&\n            (thisAssignment.EventId !== kioskState.kioskAssignmentId.EventId ||\n                thisAssignment.Event.GroupId !== kioskState.kioskAssignmentId.Event.GroupId)) {\n            location.reload();\n        }\n        if (data.Commands === 'Reload') {\n            location.reload();\n        }\n        if (data.Commands === 'Identify') {\n            clearInterval(kioskState.kioskEventLoop);\n            $('#event').hide();\n            $('#noEvent').show();\n            $('#noEvent').html(renderStatusCard('info', 'fa-tablet-alt', 'Kiosk Identification', data.Name, null));\n            setTimeout(() => {\n                location.reload();\n            }, 2000);\n            return;\n        }\n        if (data.Accepted) {\n            const Assignment = parseAssignment(data.Assignment);\n            if (Assignment && Assignment.AssignmentType == 1) {\n                const eventStart = moment(Assignment.Event.Start);\n                const eventEnd = moment(Assignment.Event.End);\n                const now = moment();\n                $('#eventTitle').text(Assignment.Event.Title);\n                $('#startTime').text(eventStart.format('MMMM Do YYYY, h:mm:ss a'));\n                $('#endTime').text(eventEnd.format('MMMM Do YYYY, h:mm:ss a'));\n                if (now.isBefore(eventStart)) {\n                    // Event hasn't started yet - show countdown\n                    $('#noEvent').hide();\n                    $('#event').show();\n                    $('#classMemberContainer').html(renderCountdown(eventStart, Assignment.Event.Title));\n                    startCountdown(eventStart);\n                }\n                else if (now.isAfter(eventEnd)) {\n                    // Event has ended\n                    $('#noEvent').hide();\n                    $('#event').show();\n                    $('#classMemberContainer').html(renderEventEnded(Assignment.Event.Title));\n                }\n                else {\n                    // Event is active - show class members\n                    updateActiveClassMembers();\n                    $('#noEvent').hide();\n                    $('#event').show();\n                }\n            }\n            else {\n                $('#noEvent').show();\n                $('#noEvent').html(renderStatusCard('success', 'fa-check-circle', 'Kiosk Ready', data.Name, \"<p class='text-muted mb-0'>This kiosk is accepted but has no active event assignment.</p>\" +\n                    \"<div class='kiosk-instructions'>\" +\n                    \"<h5><i class='fas fa-info-circle'></i> Next Steps</h5>\" +\n                    '<ol>' +\n                    '<li>Go to <strong>Kiosk Manager</strong> in the admin menu</li>' +\n                    '<li>Find this kiosk in the device list</li>' +\n                    '<li>Use the <strong>Assign</strong> dropdown to select an event</li>' +\n                    '</ol></div>'));\n                $('#event').hide();\n            }\n        }\n        else {\n            $('#noEvent').show();\n            $('#noEvent').html(renderStatusCard('pending', 'fa-hourglass-half', 'Awaiting Acceptance', data.Name, \"<p class='text-muted'>This kiosk has registered but needs to be accepted by an administrator before it can be used.</p>\" +\n                \"<div class='kiosk-instructions'>\" +\n                \"<h5><i class='fas fa-info-circle'></i> How to Accept This Kiosk</h5>\" +\n                '<ol>' +\n                '<li>Log in to ChurchCRM as an administrator</li>' +\n                '<li>Navigate to <strong>Admin → Kiosk Manager</strong></li>' +\n                '<li>Find the kiosk named <strong>' +\n                escapeHtml(data.Name) +\n                '</strong> in the list</li>' +\n                \"<li>Click the <strong><i class='fas fa-check'></i> Accept</strong> button</li>\" +\n                '<li>Assign an event to the kiosk using the dropdown</li>' +\n                '</ol>' +\n                \"<p class='mb-0'><small>This page will automatically update once the kiosk is accepted.</small></p>\" +\n                '</div>'));\n            $('#event').hide();\n        }\n    });\n}\n/**\n * Render countdown timer before event starts\n */\nfunction renderCountdown(eventStart, eventTitle) {\n    return ('<div class=\"kiosk-status-container\">' +\n        '<div class=\"card kiosk-status-card card-primary\">' +\n        '<div class=\"card-header\">' +\n        '<h3 class=\"card-title\"><i class=\"fas fa-clock mr-2\"></i>Check-in Opens Soon</h3>' +\n        '</div>' +\n        '<div class=\"card-body text-center\">' +\n        '<div class=\"kiosk-status-icon text-primary\">' +\n        '<i class=\"fas fa-clock\"></i>' +\n        '</div>' +\n        '<p class=\"text-muted mb-3\">Check-in for <strong>' +\n        escapeHtml(eventTitle) +\n        '</strong> will begin at:</p>' +\n        '<h4 class=\"text-primary mb-4\">' +\n        eventStart.format('h:mm A') +\n        '</h4>' +\n        '<div class=\"row justify-content-center mb-4\">' +\n        '<div class=\"col-auto text-center px-3\">' +\n        '<div id=\"countdown-days\" class=\"kiosk-countdown text-dark\">00</div>' +\n        '<small class=\"text-muted\">Days</small>' +\n        '</div>' +\n        '<div class=\"col-auto text-center px-3\">' +\n        '<div id=\"countdown-hours\" class=\"kiosk-countdown text-dark\">00</div>' +\n        '<small class=\"text-muted\">Hours</small>' +\n        '</div>' +\n        '<div class=\"col-auto text-center px-3\">' +\n        '<div id=\"countdown-minutes\" class=\"kiosk-countdown text-dark\">00</div>' +\n        '<small class=\"text-muted\">Minutes</small>' +\n        '</div>' +\n        '<div class=\"col-auto text-center px-3\">' +\n        '<div id=\"countdown-seconds\" class=\"kiosk-countdown text-primary\">00</div>' +\n        '<small class=\"text-muted\">Seconds</small>' +\n        '</div>' +\n        '</div>' +\n        '<p class=\"mb-0 text-muted\"><small>This page will automatically refresh when check-in opens.</small></p>' +\n        '</div>' +\n        '</div>' +\n        '</div>');\n}\n/**\n * Render event ended message\n */\nfunction renderEventEnded(eventTitle) {\n    return ('<div class=\"kiosk-status-container\">' +\n        '<div class=\"card kiosk-status-card card-success\">' +\n        '<div class=\"card-header\">' +\n        '<h3 class=\"card-title\"><i class=\"fas fa-calendar-check mr-2\"></i>Event Has Ended</h3>' +\n        '</div>' +\n        '<div class=\"card-body text-center\">' +\n        '<div class=\"kiosk-status-icon text-success\">' +\n        '<i class=\"fas fa-calendar-check\"></i>' +\n        '</div>' +\n        '<p class=\"text-muted mb-0\">Check-in for <strong>' +\n        escapeHtml(eventTitle) +\n        '</strong> has closed.</p>' +\n        '<p class=\"text-muted\">Thank you for attending!</p>' +\n        '</div>' +\n        '</div>' +\n        '</div>');\n}\n/**\n * Start the countdown timer\n */\nfunction startCountdown(eventStart) {\n    // Clear any existing countdown interval\n    if (kioskState.countdownInterval) {\n        clearInterval(kioskState.countdownInterval);\n    }\n    kioskState.countdownInterval = setInterval(() => {\n        const now = moment();\n        const duration = moment.duration(eventStart.diff(now));\n        if (duration.asSeconds() <= 0) {\n            // Event has started - reload page to show members\n            clearInterval(kioskState.countdownInterval);\n            location.reload();\n            return;\n        }\n        const days = Math.floor(duration.asDays());\n        const hours = duration.hours();\n        const minutes = duration.minutes();\n        const seconds = duration.seconds();\n        $('#countdown-days').text(String(days).padStart(2, '0'));\n        $('#countdown-hours').text(String(hours).padStart(2, '0'));\n        $('#countdown-minutes').text(String(minutes).padStart(2, '0'));\n        $('#countdown-seconds').text(String(seconds).padStart(2, '0'));\n    }, 1000);\n}\n/**\n * Render a status card\n */\nfunction renderStatusCard(statusType, iconClass, title, kioskName, bodyContent) {\n    // Use Bootstrap 4.6.2 card-primary pattern consistent with ChurchCRM\n    let cardClass = 'card-primary';\n    let iconColorClass = 'text-primary';\n    if (statusType === 'pending') {\n        cardClass = 'card-warning';\n        iconColorClass = 'text-warning';\n    }\n    else if (statusType === 'success') {\n        cardClass = 'card-success';\n        iconColorClass = 'text-success';\n    }\n    else if (statusType === 'info') {\n        cardClass = 'card-info';\n        iconColorClass = 'text-info';\n    }\n    // Validate iconClass to prevent XSS via class injection (only allow known FA icons)\n    const safeIconClass = /^fa-[a-z0-9-]+$/.test(iconClass) ? iconClass : 'fa-question-circle';\n    return ('<div class=\"card kiosk-status-card ' +\n        cardClass +\n        '\">' +\n        '<div class=\"card-header\">' +\n        '<h3 class=\"card-title\"><i class=\"fas ' +\n        safeIconClass +\n        ' mr-2\"></i>' +\n        escapeHtml(title) +\n        '</h3>' +\n        '</div>' +\n        '<div class=\"card-body text-center\">' +\n        '<div class=\"kiosk-status-icon ' +\n        iconColorClass +\n        '\">' +\n        '<i class=\"fas ' +\n        safeIconClass +\n        '\"></i>' +\n        '</div>' +\n        '<div class=\"kiosk-name\"><i class=\"fas fa-tablet-alt mr-2\"></i>' +\n        escapeHtml(kioskName) +\n        '</div>' +\n        (bodyContent ? bodyContent : '') +\n        '</div></div>');\n}\n/**\n * Check in a person\n */\nfunction checkInPerson(personId) {\n    APIRequest({\n        path: 'checkin',\n        method: 'POST',\n        data: JSON.stringify({ PersonId: personId }),\n    }).done(() => {\n        setCheckedIn(personId);\n    });\n}\n/**\n * Check out a person\n */\nfunction checkOutPerson(personId) {\n    APIRequest({\n        path: 'checkout',\n        method: 'POST',\n        data: JSON.stringify({ PersonId: personId }),\n    }).done(() => {\n        setCheckedOut(personId);\n    });\n}\n/**\n * Check out all people\n */\nfunction checkOutAll() {\n    // Disable button during processing\n    const $btn = $('#checkoutAllBtn');\n    const originalHtml = $btn.html();\n    $btn.prop('disabled', true).html('<i class=\"fas fa-spinner fa-spin mr-1\"></i>Processing...');\n    APIRequest({\n        path: 'checkoutAll',\n        method: 'POST',\n    })\n        .done(() => {\n        // Move all checked-in people to not checked in\n        $('#checkedInList .kiosk-member').each(function () {\n            const idAttr = $(this).attr('id');\n            if (!idAttr) {\n                return;\n            }\n            const numericPart = idAttr.replace('personId-', '');\n            const numericId = parseInt(numericPart, 10);\n            if (!Number.isNaN(numericId)) {\n                setCheckedOut(numericId);\n            }\n        });\n        $btn.html(originalHtml).prop('disabled', false);\n    })\n        .fail(() => {\n        $btn.html(originalHtml).prop('disabled', false);\n    });\n}\n/**\n * Set a person as checked out in the UI\n */\nfunction setCheckedOut(personId) {\n    const $personDiv = $('#personId-' + personId);\n    const $personDivButton = $personDiv.find('.checkoutButton');\n    // Update button - icon only\n    $personDivButton.removeClass('checkoutButton kiosk-btn-checkout');\n    $personDivButton.addClass('checkinButton kiosk-btn-checkin');\n    $personDivButton.html('<i class=\"fas fa-sign-in-alt\"></i>');\n    $personDivButton.attr('title', 'Check In');\n    // Remove checked-in styling\n    $personDiv.removeClass('checked-in');\n    // Remove alert button when checked out (alert buttons only shown for checked-in students)\n    $personDiv.find('.parentAlertButton').remove();\n    // Move to Not Checked In section if not already there\n    if ($personDiv.closest('#notCheckedInList').length === 0) {\n        $personDiv.detach().appendTo('#notCheckedInList');\n        updateMemberCounts();\n    }\n}\n/**\n * Set a person as checked in in the UI\n */\nfunction setCheckedIn(personId) {\n    const $personDiv = $('#personId-' + personId);\n    const $personDivButton = $personDiv.find('.checkinButton');\n    // Update button - icon only\n    $personDivButton.removeClass('checkinButton kiosk-btn-checkin');\n    $personDivButton.addClass('checkoutButton kiosk-btn-checkout');\n    $personDivButton.html('<i class=\"fas fa-sign-out-alt\"></i>');\n    $personDivButton.attr('title', 'Check Out');\n    // Add checked-in styling\n    $personDiv.addClass('checked-in');\n    // Add alert button if notifications are enabled and it doesn't already exist\n    if (kioskState.notificationsEnabled && $personDiv.find('.parentAlertButton').length === 0) {\n        const $actionsDiv = $personDiv.find('.kiosk-member-actions');\n        const alertBtn = $('<button>', {\n            class: 'kiosk-btn kiosk-btn-alert parentAlertButton',\n            'data-personid': personId,\n            title: 'Parent Alert',\n        }).append($('<i>', { class: 'fas fa-bell' }));\n        $actionsDiv.append(alertBtn);\n    }\n    // Move to Checked In section if not already there\n    if ($personDiv.closest('#checkedInList').length === 0) {\n        $personDiv.detach().appendTo('#checkedInList');\n        updateMemberCounts();\n    }\n}\n/**\n * Trigger a parent notification\n */\nfunction triggerNotification(personId) {\n    // Get the student's name for feedback\n    const $personDiv = $('#personId-' + personId);\n    const studentName = $personDiv.find('.kiosk-member-name').text().trim() || 'Student';\n    // Visual feedback - disable button and show sending state\n    const $alertBtn = $personDiv.find('.parentAlertButton');\n    $alertBtn.prop('disabled', true).addClass('sending');\n    $alertBtn.find('i').removeClass('fa-bell').addClass('fa-spinner fa-spin');\n    APIRequest({\n        path: 'triggerNotification',\n        method: 'POST',\n        data: JSON.stringify({ PersonId: personId }),\n    })\n        .done(() => {\n        // Show success notification\n        if (typeof getCRM().notify === 'function') {\n            getCRM().notify('Parent alert sent for ' + studentName, { type: 'success', delay: 4000 });\n        }\n        else {\n            // Fallback for kiosk view without full CRM.notify\n            showKioskNotification('Parent alert sent for ' + studentName, 'success');\n        }\n        // Reset button after short delay\n        setTimeout(() => {\n            $alertBtn.prop('disabled', false).removeClass('sending');\n            $alertBtn.find('i').removeClass('fa-spinner fa-spin').addClass('fa-bell');\n        }, 2000);\n    })\n        .fail(() => {\n        // Show error notification\n        if (typeof getCRM().notify === 'function') {\n            getCRM().notify('Failed to send parent alert', { type: 'error', delay: 4000 });\n        }\n        else {\n            showKioskNotification('Failed to send parent alert', 'error');\n        }\n        // Reset button\n        $alertBtn.prop('disabled', false).removeClass('sending');\n        $alertBtn.find('i').removeClass('fa-spinner fa-spin').addClass('fa-bell');\n    });\n}\n/**\n * Simple notification for kiosk mode (no Notyf dependency)\n */\nfunction showKioskNotification(message, type) {\n    const $notification = $('<div>', {\n        class: 'kiosk-notification kiosk-notification-' + type,\n        text: message,\n    });\n    $('body').append($notification);\n    // Animate in\n    setTimeout(() => {\n        $notification.addClass('show');\n    }, 10);\n    // Remove after delay\n    setTimeout(() => {\n        $notification.removeClass('show');\n        setTimeout(() => {\n            $notification.remove();\n        }, 300);\n    }, 4000);\n}\n/**\n * Enter full screen mode\n */\nfunction enterFullScreen() {\n    const docEl = document.documentElement;\n    if (docEl.requestFullscreen) {\n        docEl.requestFullscreen();\n    }\n    else if (docEl.mozRequestFullScreen) {\n        docEl.mozRequestFullScreen();\n    }\n    else if (docEl.webkitRequestFullscreen) {\n        docEl.webkitRequestFullscreen();\n    }\n    else if (docEl.msRequestFullscreen) {\n        docEl.msRequestFullscreen();\n    }\n}\n/**\n * Exit full screen mode\n */\nfunction exitFullScreen() {\n    const doc = document;\n    if (doc.exitFullscreen) {\n        doc.exitFullscreen();\n    }\n    else if (doc.mozCancelFullScreen) {\n        doc.mozCancelFullScreen();\n    }\n    else if (doc.webkitExitFullscreen) {\n        doc.webkitExitFullscreen();\n    }\n}\n/**\n * Display person info (placeholder)\n */\nfunction displayPersonInfo(_personId) {\n    // Not implemented\n}\n/**\n * Start the event loop\n */\nfunction startEventLoop() {\n    kioskState.kioskEventLoop = setInterval(heartbeat, 2000);\n}\n/**\n * Stop the event loop\n */\nfunction stopEventLoop() {\n    if (kioskState.kioskEventLoop) {\n        clearInterval(kioskState.kioskEventLoop);\n    }\n}\n// Export the kiosk object for global access\n// Use Object.defineProperty for the notificationsEnabled getter to reflect actual state\nconst kiosk = {\n    get notificationsEnabled() {\n        return kioskState.notificationsEnabled;\n    },\n    escapeHtml,\n    APIRequest,\n    getPhotoUrl,\n    renderClassMember,\n    updateMemberCounts,\n    renderBirthdaySection,\n    renderBirthdayCard,\n    updateActiveClassMembers,\n    renderNoMembersMessage,\n    renderErrorMessage,\n    heartbeat,\n    renderCountdown,\n    renderEventEnded,\n    startCountdown,\n    renderStatusCard,\n    checkInPerson,\n    checkOutPerson,\n    checkOutAll,\n    setCheckedOut,\n    setCheckedIn,\n    triggerNotification,\n    showKioskNotification,\n    enterFullScreen,\n    exitFullScreen,\n    displayPersonInfo,\n    startEventLoop,\n    stopEventLoop,\n};\n// Attach to window.CRM.kiosk for global access (for external use)\nif (!window.CRM) {\n    window.CRM = {};\n}\nwindow.CRM.kiosk = kiosk;\n\n\n//# sourceURL=webpack://churchcrm/./webpack/kiosk/kiosk-jsom.ts?\n}",
            );

            /***/
        },

        /******/
    };
    /************************************************************************/
    /******/ // The module cache
    /******/ var __webpack_module_cache__ = {};
    /******/
    /******/ // The require function
    /******/ function __webpack_require__(moduleId) {
        /******/ // Check if module is in cache
        /******/ var cachedModule = __webpack_module_cache__[moduleId];
        /******/ if (cachedModule !== undefined) {
            /******/ return cachedModule.exports;
            /******/
        }
        /******/ // Check if module exists (development only)
        /******/ if (__webpack_modules__[moduleId] === undefined) {
            /******/ var e = new Error("Cannot find module '" + moduleId + "'");
            /******/ e.code = "MODULE_NOT_FOUND";
            /******/ throw e;
            /******/
        }
        /******/ // Create a new module (and put it into the cache)
        /******/ var module = (__webpack_module_cache__[moduleId] = {
            /******/ // no module.id needed
            /******/ // no module.loaded needed
            /******/ exports: {},
            /******/
        });
        /******/
        /******/ // Execute the module function
        /******/ __webpack_modules__[moduleId](module, module.exports, __webpack_require__);
        /******/
        /******/ // Return the exports of the module
        /******/ return module.exports;
        /******/
    }
    /******/
    /************************************************************************/
    /******/ /* webpack/runtime/define property getters */
    /******/ (() => {
        /******/ // define getter functions for harmony exports
        /******/ __webpack_require__.d = (exports, definition) => {
            /******/ for (var key in definition) {
                /******/ if (__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
                    /******/ Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
                    /******/
                }
                /******/
            }
            /******/
        };
        /******/
    })();
    /******/
    /******/ /* webpack/runtime/hasOwnProperty shorthand */
    /******/ (() => {
        /******/ __webpack_require__.o = (obj, prop) => Object.prototype.hasOwnProperty.call(obj, prop);
        /******/
    })();
    /******/
    /******/ /* webpack/runtime/make namespace object */
    /******/ (() => {
        /******/ // define __esModule on exports
        /******/ __webpack_require__.r = (exports) => {
            /******/ if (typeof Symbol !== "undefined" && Symbol.toStringTag) {
                /******/ Object.defineProperty(exports, Symbol.toStringTag, { value: "Module" });
                /******/
            }
            /******/ Object.defineProperty(exports, "__esModule", { value: true });
            /******/
        };
        /******/
    })();
    /******/
    /************************************************************************/
    /******/
    /******/ // startup
    /******/ // Load entry module and return exports
    /******/ // This entry module can't be inlined because the eval devtool is used.
    /******/ var __webpack_exports__ = __webpack_require__("./webpack/kiosk/index.ts");
    /******/
    /******/
})();
